import { Link, useLocation } from 'react-router-dom'
import { Apple, Calendar } from 'lucide-react'
import Footer from './Footer'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <div className="layout-nutrition">
      <header className="header-nutrition">
        <div className="container">
          <div className="header-content-nutrition">
            <Link to="/" className="logo-nutrition">
              <div className="logo-icon-nutrition">
                <Apple size={32} />
              </div>
              <div className="logo-text-nutrition">
                <span className="logo-title-nutrition">NutriCare</span>
                <span className="logo-subtitle-nutrition">Консультации нутрициолога</span>
              </div>
            </Link>
            <nav className="nav-nutrition">
              <Link 
                to="/" 
                className={`nav-link-nutrition ${location.pathname === '/' ? 'active' : ''}`}
              >
                Мои консультации
              </Link>
              <Link 
                to="/enroll" 
                className={`nav-link-nutrition ${location.pathname === '/enroll' ? 'active' : ''}`}
              >
                Записаться
              </Link>
            </nav>
          </div>
        </div>
      </header>
      <main className="main-nutrition">
        {children}
      </main>
      <Footer />
    </div>
  )
}

export default Layout

